<?php

namespace Nidec\LaravelOauthClient\Tests;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;

class AuthenticationTest extends TestCase
{
    private array $user;

    protected function setUp(): void
    {
        parent::setUp();
        $this->user = [
            'id' => 1,
            "name" => "John Doe",
            "email" => "john.doe@nidec-asi.com",
            "email_verified_at" => null,
            "two_factor_confirmed_at" => null,
            "created_at" => date("c"),
            "updated_at" => date("c")
        ];
    }

    public function testApiAuthenticated()
    {
        $token = '123ABC';

        Http::fake([
            config('oauth_client.me_endpoint') => Http::response([
                'user' => $this->user,
                'scopes' => [
                ]
            ]),
        ]);

        $response = $this->withHeaders([
            'Accept' => 'application/json',
        ])->withToken($token)->get('api/ping');

        $response->assertStatus(200);
    }

    public function testWebAuthenticated()
    {
        $token = '123ABC';

        Http::fake([
            config('oauth_client.me_endpoint') => Http::response([
                'user' => [
                    'id' => 1,
                    "name" => "John Doe",
                    "email" => "john.doe@nidec-asi.com",
                    "email_verified_at" => null,
                    "two_factor_confirmed_at" => null,
                    "created_at" => date("c"),
                    "updated_at" => date("c")
                ],
                'scopes' => [
                ]
            ]),
        ]);

        $response = $this->withSession(['access_token' => $token])->get('web/index');

        $response->assertStatus(200);
    }

    public function testApiUnauthenticated()
    {
        $response = $this->withHeaders([
            'Accept' => 'application/json',
        ])->get('api/ping');

        $response->assertStatus(401);
    }

    public function testWebUnauthenticated()
    {
        $response = $this->get('web/index');

        $response->assertRedirectToRoute('login');
    }

    public function testLoginSuccess()
    {
        $token = '123ABC';

        $response = $this->get(route('login'));

        $response->assertRedirectContains(config('oauth_client.authorize_endpoint'));

        Http::fake([
            config('oauth_client.token_endpoint') => Http::response([
                'access_token' => $token,
                'refresh_token' => $token,
                'expires_in' => 3600,
            ])
        ]);

        $state = Str::random(40);

        $response = $this->withSession(['state' => $state])->get(route('oauth.callback') . '?state=' . $state);

        $response->assertRedirect('/');
    }
}
