<?php

namespace Nidec\LaravelOauthClient;

use Illuminate\Auth\GenericUser;
use Illuminate\Foundation\Auth\Access\Authorizable;

class User extends GenericUser
{
    use Authorizable;

    public array $scopes = [];

    public function __construct(array $attributes)
    {
        $this->scopes = $attributes['scopes'] ?? [];
        parent::__construct($attributes['user']);
    }

    public function hasScopes(string|array $scopes): bool
    {
        if (is_array($scopes)) {
            return count(array_intersect($scopes, $this->scopes)) === count($scopes);
        } else {
            return in_array($scopes, $this->scopes);
        }
    }
}
