# Laravel OAuth Client

A lightweight package that set up an OAuth client to connect to the authentication server.

## Install

The package is distributed by a private composer repository.

First, add the repository to your composer config. Either add this snippet to your composer.json:
```json
"repositories": [
    {
        "name": "nidec",
        "type": "composer",
        "url": "https://satis.nidec-asi-online.com"
    }
]
```

or run this command in the CLI to do it automatically:

```shell
composer config repositories.aguignard composer https://satis.nidec-asi-online.com
```

Then, install the package from the repository:

```shell
composer require nidec/laravel-oauth-client
```

## Configuration

### Publish the config

After install, you should publish the config:

```shell
php artisan vendor:publish
```
Select `Nidec\LaravelOAuthClient\ServiceProvider` in the list.
It creates the file `config/oauth_client.php`.

### Configure variables

You MUST define the following variable in your .env (or directly change the value in `config/oauth_client.php`):
```dotenv
AUTH_CLIENT_ID={client_id}
```

This is the client id created by the authentication server to identify your app.  
You must obtain it from the authentication server first.

You SHOULD define the following variable:
```dotenv
AUTH_SCOPES=my_scope,my_other_scope
```
This defines the scopes in which your app operates, separated by commas.  
For example, if your app needs to retrieve the user's tickets, the token should have the scope `tickets:read`.  
If no scopes are provided, your client will only be able to fetch the connected user's infos.

> There is no mean yet to list all available scopes. Furthermore, if you need to add one or more scopes,
> they must be registered in the authentication service provider, otherwise your authorization request might get denied.

Additionally, you CAN define the following variables if you don't want to use the default configuration:
```dotenv
AUTH_SERVER=https://my-own-server.org
AUTH_AUTHORIZE_ENDPOINT=/my/authorization/endpoint
AUTH_TOKEN_ENDPOINT=/my/token/endpoint
AUTH_ME_ENDPOINT=/my/me/endpoint
```

> Don't forget to put the `/` at the start of the endpoints

### Add the guard

Then, add the `oauth` guard to your `config/auth.php`:

```php
'guards' => [
    'oauth' => [
        'driver' => 'oauth',
    ]
],
```

## Usage

Once correctly configured, you just have to add the guard to your routes:
```php
Route::middleware('auth:oauth')->group(function () {
    // Your routes
});
```

Now, every time someone will try to call one of your protected routes, the guard will check if the request has a bearer token
or if there is an access token in session. It will validate the token against the authentication server and hydrate the
user with its infos and the token scopes.

If there is no token, it will instead redirect the user to the authentication server's login interface. After login,
the user will be redirected to the homepage of your app and will be authenticated for further requests until he destroys
his session.

In the case of an api call (`application/json` requested) the request will simply be denied.
A token should be retrieved by external means and set as bearer token on the request.


### Check scopes

You can check scopes on a connected user with
```php
Auth::user()->hasScopes(['my_scope']) // You can pass an array or a string for a single scope
```
This can be useful if your client also provide a service to ensure another client does not overstep its own scope.

> e.g. Your client manages tickets and offers an api that provide the user's tickets. A client that manage documents sends a
> request to your api to retrieve the user's tickets, however the token does not have the `tickets:read` scope
> because this is typically out of this client scope to read tickets, so the request is denied
