<?php

namespace Nidec\LaravelApiClient;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Support\ServiceProvider as BaseServiceProvider;

class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        $this->app->bind(User::class, function (Application $app, array $attributes = []): User {
            return new User($attributes);
        });
    }

    public function boot(): void
    {
        $this->publishes([
            __DIR__ . '/../config/oauth_client.php' => config_path('oauth_client.php'),
        ], 'config');

        $this->loadRoutesFrom(__DIR__ . '/../routes/web.php');

        \Auth::extend('oauth', function () {
            return new OAuthGuard();
        });
    }
}
