<?php

namespace Nidec\LaravelApiClient;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Support\Collection;
use Livewire\Wireable;

class ResourceCollection extends Collection implements Wireable, Arrayable
{
    public ?string $type = null;

    public function __construct(array|Collection $resources, string $resourceClass = null)
    {
        $items = [];
        foreach ($resources as $key => $resource) {
            $this->type = $this->type ?? $resourceClass;
            if ($resource instanceof Resource) {
                $this->type = get_class($resource);
                $items[$key] = $resource;
            } elseif (!empty($resourceClass)) {
                $items[$key] = new $resourceClass($resource);
            } elseif (is_array($resource)) {
                $items[$key] = new ResourceCollection($resource);
            } else {
                $items[$key] = $resource;
            }
        }
        parent::__construct($items);
    }

    public function toLivewire()
    {
        return [
            'type' => $this->type,
            'items' => $this->items,
        ];
    }

    public static function fromLivewire($value): static
    {
        return new static($value['items'], $value['type']);
    }

    public function toArray(): array
    {
        $array = [];
        foreach ($this->items as $item) {
            $array[] = $item->toArray();
        }
        return $array;
    }
}
