<?php

namespace Nidec\LaravelApiClient;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Support\Str;
use Livewire\Wireable;
use ReflectionClass;
use ReflectionProperty;
use ReflectionUnionType;
use Throwable;

abstract class Resource implements Wireable, Arrayable
{
    public function __construct(array $params = [])
    {
        foreach ($params as $key => $value) {
            $key = Str::camel($key);
            if (property_exists($this, $key)) {
                $property = new ReflectionProperty($this, $key);
                $types = $property->getType() instanceof ReflectionUnionType
                    ? $property->getType()->getTypes()
                    : [$property->getType()];
                $castedValue = null;
                foreach ($types as $type) {
                    $type = $type->getName();
                    try {
                        if ($type === ResourceCollection::class && count($property->getAttributes(Collection::class)) > 0) {
                            $type = $property->getAttributes(Collection::class)[0]->getArguments()[0];
                            $castedValue = $type::collection($value);
                            break;
                        } elseif (class_exists($type)) {
                            $castedValue = new $type($value);
                            break;
                        }
                    } catch (Throwable) {
                        // Si l'un des types possibles est une Resource ou ResourceCollection,
                        // on essaye de cast la valeur. Si ça ne marche la valeur est probablement
                        // d'un autre type.
                        continue;
                    }
                }
                $this->$key = $castedValue ?? $value;
            }
        }
    }

    public static function collection(array $params = []): ResourceCollection
    {
        return new ResourceCollection($params, static::class);
    }

    public function toLivewire(): static
    {
        return $this;
    }

    public static function fromLivewire($value): static
    {
        return new static($value);
    }

    public function toArray(): array
    {
        $array = [];
        foreach ((new ReflectionClass($this))->getProperties() as $property) {
            if ($property->isPublic() && $property->isInitialized($this)) {
                $array[$property->getName()] = $property->getType() instanceof Arrayable ? $this->{$property->name}->toArray() : $this->{$property->name};
            }
        }
        return $array;
    }
}
